<?php
ini_set('display_errors', 1);
if(session_status() === PHP_SESSION_NONE) session_start();
include(__DIR__ . '/functions.php');
$adTypeJsonPath = __DIR__ . '/ad_type.json';
$adb = new SQLite3('./api/.adb.db');
$adTypeData = json_decode(file_get_contents($adTypeJsonPath), true);
$currentAdType = $adTypeData['adType'] ?? 'manual';

if ($currentAdType === 'tmdb') {
    $adsPageUrl = "tmdb_api.php";
} else {
    $adsPageUrl = "ads.php";
}

if (!isset($_SESSION['name'])) {
    header("Location: index.php");
    exit;
}

$log_check = $db->select('users', '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]['username'] : null;

if ($_SESSION['name'] !== $loggedinuser) {
    header("Location: index.php");
    exit;
}

function __($text) {
    static $translations = null;

    if ($translations === null) {
        $langFile = __DIR__ . '/lang_tr.json';
        if (file_exists($langFile)) {
            $translations = json_decode(file_get_contents($langFile), true);
        } else {
            $translations = [];
        }
    }

    return $translations[$text] ?? $text;
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<meta name="author" content="WCTV IBO 3.8">
	<title>TELAIBO 4.1</title>
	<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
	<link href="css/themes/darkly/bootstrap.css" rel="stylesheet" title="main">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.2.3/animate.min.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
	<link href="css/simple-sidebar.css" rel="stylesheet">
</head>
<body>
<style>
#sidebar-wrapper {
  background-color: #303030;
  color: #fff;
  height: 100vh;
  display: flex;
  flex-direction: column;
  justify-content: space-between;
}

.sidebar-footer {
  text-align: center;
  padding: 15px;
  font-size: 0.9em;
  background-color: #222;
  color: #bbb;
}

.list-group-item {
  background-color: transparent;
  color: #fff;
}

.list-group-item:hover {
  background-color: #444;
  color: #fff;
}

#pageMessages {
  left: 50%;
  transform: translateX(-50%);
  position: fixed;
  text-align: center;
  top: 5px;
  width: 60%;
  z-index: 9999;
  border-radius: 0px;
}

.alert .close {
  position: absolute;
  top: 5px;
  right: 5px;
  font-size: 1em;
}
</style>

<div class="d-flex" id="wrapper">
	<!-- Sidebar-->
	<div id="sidebar-wrapper">
	  <div class="sidebar-heading text-center py-3">
	    <strong>TELAIBO 4.1</strong>
	  </div>
	  <div class="list-group list-group-flush">
          <a class="list-group-item list-group-item-action" href="dns.php"><i class="fa fa-cogs"></i> <?= __("Add DNS") ?></a>
          <a class="list-group-item list-group-item-action" href="playlists.php"><i class="fa fa-user"></i> <?= __("MAC Users") ?></a>
          <a class="list-group-item list-group-item-action" href="gestor.php"><i class="fa fa-user"></i> <?= __("Manager") ?></a>
          <a class="list-group-item list-group-item-action" href="expirando.php"><i class="fa fa-user"></i> <?= __("Expiring") ?></a>
          <div class="list-group-item list-group-item-action dropdown">
              <a href="#" class="dropdown-toggle" id="visualizationMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                  <i class="fa fa-eye"></i> <?= __("Görselleştirme") ?>
              </a>
              <div class="dropdown-menu" aria-labelledby="visualizationMenu" style="background-color: #303030; border: none;">
                  <a class="dropdown-item" href="themes.php" style="background-color: #303030; color: #fff;"> <?= __("Themes") ?> </a>
                  <a class="dropdown-item" href="fundo.php" style="background-color: #303030; color: #fff;"> <?= __("Banners") ?> </a>
                  <a class="dropdown-item" href="tipo.php" style="background-color: #303030; color: #fff;"> <?= __("Banner Types") ?> </a>
                  <a class="dropdown-item" href="mRTXBGlogo.php" style="background-color: #303030; color: #fff;"> <?= __("Change Logo") ?> </a>
                  <a class="dropdown-item" href="mRTXBGImage.php" style="background-color: #303030; color: #fff;"> <?= __("Change Background") ?> </a>
                  <a class="dropdown-item" href="tipodefundo.php" style="background-color: #303030; color: #fff;"> <?= __("Background Type") ?> </a>
              </div>
          </div>
          <a class="list-group-item list-group-item-action" href="settings.php"><i class="fa fa-cog"></i> <?= __("MAC Screen Description") ?></a>
          <a class="list-group-item list-group-item-action" href="qr.php"><i class="fa fa-qrcode"></i> <?= __("Lists Page") ?></a>
          <a class="list-group-item list-group-item-action" href="qrlogin.php"><i class="fa fa-lock"></i> <?= __("Login Page") ?></a>
          <a class="list-group-item list-group-item-action" href="fundoo.php"><i class="fa fa-cogs"></i> <?= __("Game Section Banners") ?></a>
          <a class="list-group-item list-group-item-action" href="siteesportes.php"><i class="fa fa-gamepad"></i> <?= __("Game Section Page") ?></a>
          <a class="list-group-item list-group-item-action" href="tipo2.php"><i class="fa fa-list-alt"></i> <?= __("What to Show in Game Section") ?></a>
          <a class="list-group-item list-group-item-action" href="site.php"><i class="fa fa-globe"></i> <?= __("Web Page") ?></a>
          <a class="list-group-item list-group-item-action" href="mRTXinAppText.php"><i class="fa fa-envelope"></i> <?= __("Messages") ?></a>
          <a class="list-group-item list-group-item-action" href="user.php"><i class="fa fa-user"></i> <?= __("Account") ?></a>
      </div>
	  <div class="sidebar-footer" style="background-color: #303030;">
	    <a href="https://t.me/Rain_Bow65" target="_blank">&copy; <?=date("Y")?>RainBow</a>
	  </div>
	</div>

	<div id="page-content-wrapper">
	  <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
		<button class="btn btn-primary" id="menu-toggle">
		  <img src="img/logo.png" width="25" height="25" alt="">
		</button>
		<div class="center" id="pageMessages"></div>
		<a href="logout.php" class="btn btn-danger ml-auto mr-1">Logout</a>
	  </nav>

	  <div class="container-fluid"><br>
