<?php
include('includes/header.php');

// Função para obter a última opção salva
function obterUltimaOpcao()
{
    $arquivo = "./api/ultima_opcao1.txt";
    if (file_exists($arquivo)) {
        return file_get_contents($arquivo);
    } else {
        return "";
    }
}

// Função para obter o rótulo da opção selecionada
function obterRotuloOpcao($opcao)
{
    switch ($opcao) {
        case 'siteesportes.php':
            return 'Pagina.';
        case 'menadss.php':
            return 'Manual.';
    }
}

// Função para obter o link da imagem para cada opção
function obterLinkImagem($opcao)
{
    switch ($opcao) {
        case 'menadss.php':
            return 'https://i.imgur.com/r5bVG7s.jpeg';
        case 'paginaesportes.php': // Corrigido para coincidir com o valor no formulário
            return 'https://i.imgur.com/DW6Mc64.jpeg';
    }
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $opcao_selecionada = $_POST["opcoes"];
    file_put_contents("./api/opcao12.txt", $opcao_selecionada);
    file_put_contents("./api/ultima_opcao12.txt", $opcao_selecionada);

    if ($opcao_selecionada === 'note.php') {
        echo '<meta http-equiv="refresh" content="0; URL=mRTXinAppText.php">';
        exit;
    } elseif ($opcao_selecionada === 'paginaesportes.php') {
        echo '<meta http-equiv="refresh" content="0; URL=siteesportes.php">';
        exit;
    } elseif ($opcao_selecionada === 'menads.php') {
        echo '<meta http-equiv="refresh" content="0; URL=fundoo.php">';
        exit;
    }
}
?>

        <div class="col-md-12">
            <div class="card">
                <div class="card-header bg-primary text-white text-center">
                    <h2 class="mb-0">Tipo de Banner</h2>
                </div>
                <div class="card-body">
                    <form method="POST" action="" enctype="multipart/form-data">
                        <div class="row">
                            <?php
                            $opcoes = [
                                'menadss.php' => 'Manual',
                                'paginaesportes.php' => 'Página Web'
                            ];
                            ?>
                            <?php foreach ($opcoes as $valor => $rotulo) : ?>
                                <div class="col-md-6 mb-4">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="opcoes" id="<?php echo $valor; ?>" value="<?php echo $valor; ?>" <?php if (obterUltimaOpcao() === $valor) echo 'checked'; ?>>
                                        <label class="form-check-label d-block" for="<?php echo $valor; ?>">
                                            <strong><?php echo $rotulo; ?></strong>
                                        </label>
                                        <?php $link_imagem = obterLinkImagem($valor); ?>
                                        <img src="<?php echo $link_imagem; ?>" alt="Imagem de exemplo" class="img-fluid rounded shadow-sm mt-2">
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <div class="text-center">
                            <button type="submit" name="submit" class="btn btn-primary">Salvar</button>
                        </div>
                        <?php $ultima_opcao = obterUltimaOpcao(); ?>
                        <?php if (!empty($ultima_opcao)) : ?>
                            <p class="text-success text-center mt-3">
                                Última opção selecionada: <strong><?php echo obterRotuloOpcao($ultima_opcao); ?></strong>
                            </p>
                        <?php endif; ?>
                    </form>
                </div>
            </div>
        </div>


<?php include('includes/footer.php'); ?>